<?php
include "header.php";
?>

<!-- Main Working Space Start -->

<div class="col-md-12">
<div
          class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
        >
        <div style=" height: 73vh;">
    <div class="card my-4">
        <div class="col-md-12 card-header " >
            <div class="row">
              <div class="col-md-3">
                <h3 class=""> Import Lead </h3>
              </div>
              <div class="col-md-4">
              <nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
                <ol class="breadcrumb mt-2">
                  <li class="breadcrumb-item"><a href="index.php">Leads</a></li>
                  <li class="breadcrumb-item active" aria-current="page">Import Leads</li>
                </ol>
              </nav>
              </div>
            </div>
          </div>
            <div class="card-body">
              <div class="col-md-12">
              <form action="import.php" method="POST" enctype="multipart/form-data">
                  <div class="row">
                    <div class="col-md-6">
                      <input type="file" name="file" class="form-control">
                    </div>
                    <div class="col-md-6">
                      <div class="row">
                        <div class="col-md-3">
                          <button type="submit" name="submit_file" class="btn btn-primary">Import</button>
                        </div>
                </form>
                      <div class="col-md-3">
                      <form action="import_try.php" method="POST">
                        <input type="submit" class="btn btn-success" name="export_excel" value="Sample Download">
                      </form>
                    </div>            
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div> 
      </div>
    </div>


</div>
<!-- Main Working Space End -->
<script>

const excel_file = document.getElementById('excel_file');

excel_file.addEventListener('change', (event) => {

    if(!['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/vnd.ms-excel'].includes(event.target.files[0].type))
    {
        document.getElementById('excel_data').innerHTML = '<div class="alert alert-danger">Only .xlsx or .xls file format are allowed</div>';

        excel_file.value = '';

        return false;
    }

    var reader = new FileReader();

    reader.readAsArrayBuffer(event.target.files[0]);

    reader.onload = function(event){

        var data = new Uint8Array(reader.result);

        var work_book = XLSX.read(data, {type:'array'});

        var sheet_name = work_book.SheetNames;

        var sheet_data = XLSX.utils.sheet_to_json(work_book.Sheets[sheet_name[0]], {header:1});

        if(sheet_data.length > 0)
        {
            var table_output = '<table class="table table-striped table-bordered">';

            for(var row = 0; row < sheet_data.length; row++)
            {

                table_output += '<tr>';

                for(var cell = 0; cell < sheet_data[row].length; cell++)
                {

                    if(row == 0)
                    {

                        table_output += '<th>'+sheet_data[row][cell]+'</th>';

                    }
                    else
                    {

                        table_output += '<td>'+sheet_data[row][cell]+'</td>';

                    }

                }

                table_output += '</tr>';

            }

            table_output += '</table>';

            document.getElementById('excel_data').innerHTML = table_output;
        }

        excel_file.value = '';

    }

});

</script>


<?php
include "footer.php";
?>