<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$domain = "coimbatorerealtors.in";

// Function to get and print DNS TXT records
function get_dns_record($recordType, $domain) {
    $records = dns_get_record($domain, DNS_TXT);
    
    if ($records === false) {
        return "DNS query failed.";
    }

    foreach ($records as $record) {
        if (isset($record['txt']) && strpos($record['txt'], $recordType) !== false) {
            return $record['txt'];
        }
    }
    return "Not Found";
}

// Check SPF Record
echo "SPF Record:\n" . get_dns_record("v=spf1", $domain) . "\n\n";

// Check DKIM Record (Change selector if needed)
$dkim_selector = "default"; // Usually "default" for Microsoft 365, but check your DNS
echo "DKIM Record:\n" . get_dns_record("v=DKIM1", $dkim_selector . "._domainkey." . $domain) . "\n\n";

// Check DMARC Record
echo "DMARC Record:\n" . get_dns_record("v=DMARC1", "_dmarc." . $domain) . "\n\n";

// Log errors to a file
function log_error($message) {
    error_log(date("[Y-m-d H:i:s] ") . $message . "\n", 3, "error_log.txt");
}

// Email Sending
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';
require 'PHPMailer/src/Exception.php';

$mail = new PHPMailer(true);

try {
    $mail->isSMTP();
    $mail->Host = 'smtp.office365.com'; 
    $mail->SMTPAuth = true;
    $mail->Username = 'support@coimbatorerealtors.in';
    $mail->Password = 'RF2wgLUcwSyrZq2'; // SECURITY RISK: Use an env variable instead
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port = 587;

    $mail->setFrom('support@coimbatorerealtors.in', 'Coimbatore Realtors');
    $mail->addAddress('vijiramesh95@gmail.com');

    $mail->isHTML(true);
    $mail->Subject = 'Test Email';
    $mail->Body = '<p>This is a test email to check email sending.</p>';

    $mail->send();
    echo '✅ Email Sent Successfully!';
} catch (Exception $e) {
    $errorMessage = "❌ Email Sending Failed: " . $mail->ErrorInfo;
    echo $errorMessage;
    log_error($errorMessage);
}
?>
